#include "module.h"
#include <yandex/maps/wiki/validator/check.h>

#include "poi_categories.h"
#include "../utils/names.h"

#include <unordered_map>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using categories::POI_NM;

namespace {

template<class CategoryName>
bool performCheck(CheckContext* context)
{
    // Assigned object id to POI names datum map
    std::unordered_map<TId, std::unordered_map<NameDatum, TId>> poiNames;

    context->objects<CategoryName>().visit([&](const Poi* poi)
    {
        for (const auto& assignedObj: poi->assignedObjects()) {
            for (NameDatum& officialNameDatum
                    : utils::officialNames<POI_NM>(poi, context)) {
                if (!utils::isNameEmpty(officialNameDatum.name)) {
                    auto insertionResult = poiNames[assignedObj.id].insert(
                            {std::move(officialNameDatum), poi->id()});
                    if (!insertionResult.second) {
                        context->error("duplicate-poi-names",
                            boost::none,
                            { assignedObj.id,
                              poi->id(),
                              insertionResult.first->second });
                    }
                }
            }
        }
    });

    return true;
};

template<class... Categories>
void performChecks(CheckContext* context)
{
    auto performed = {performCheck<Categories>(context)...};
    (void)performed;
}

} // namespace

VALIDATOR_SIMPLE_CHECK( poi_uniqueness, POI_NM, POI_CATEGORIES )
{
    performChecks<POI_CATEGORIES>(context);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
