#include "module.h"

#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"
#include "../utils/misc.h"

#include <unordered_map>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using categories::RD;
using categories::RD_NM;
using categories::RD_EL;

VALIDATOR_SIMPLE_CHECK( rd_ad_uniqueness, RD, RD_NM, RD_EL )
{
    std::unordered_map<TId, std::unordered_map<NameDatum, TId>> roadNames;

    context->objects<RD>().visit([&](const Road* road)
    {
        if (road->associatedObject().type == Road::AssociatedObject::Type::NotSet) {
            return;
        }

        for (NameDatum& officialNameDatum
                : utils::officialNames<RD_NM>(road, context)) {
            if (utils::isNameEmpty(officialNameDatum.name)) {
                continue;
            }

            auto insertionResult = roadNames[road->associatedObject().id].insert(
                std::make_pair(std::move(officialNameDatum), road->id()));
            if (insertionResult.second) {
                continue;
            }

            std::vector<TId> loadedRdElIds;
            for (auto id : road->elements()) {
                if (context->objects<RD_EL>().loaded(id)) {
                    loadedRdElIds.push_back(id);
                }
            }
            auto description = "ad-duplicate-road-names";
            auto errorIds = { road->associatedObject().id, road->id(), insertionResult.first->second };
            if (loadedRdElIds.empty()) {
                context->error(description, boost::none, errorIds);
            } else {
                auto rdElId = loadedRdElIds[loadedRdElIds.size() / 2];
                auto geom = utils::geomForReport(context->objects<RD_EL>().byId(rdElId));
                context->error(description, geom, errorIds);
            }
        }
    });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps

