#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <functional>

using maps::wiki::validator::categories::REGION;
using maps::wiki::validator::categories::AD_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_SIMPLE_CHECK( region_naming, REGION, AD_NM )
{
    context->objects<REGION>().visit([&](const Region* region) {
        utils::runBasicNamesCheck<AD_NM>(region, context);
    });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
