#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <functional>

using maps::wiki::validator::categories::RELIEF;
using maps::wiki::validator::categories::RELIEF_POINT;
using maps::wiki::validator::categories::RELIEF_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( relief_naming, relief, RELIEF, RELIEF_NM )
{
    context->objects<RELIEF>().visit(
        [&](const ContourFeature* relief) {
            utils::runBasicNamesCheck<RELIEF_NM>(relief, context);
        }
    );
}

VALIDATOR_CHECK_PART( relief_naming, point, RELIEF_POINT, RELIEF_NM )
{
    context->objects<RELIEF_POINT>().visit(
        [&](const PointFeature* point) {
            utils::runBasicNamesCheck<RELIEF_NM>(point, context);
        }
    );
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
