#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/relations_checks.h"

using maps::wiki::validator::categories::RELIEF;
using maps::wiki::validator::categories::RELIEF_FC;
using maps::wiki::validator::categories::RELIEF_EL;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART(
        relief_relations, face_elements_relations, RELIEF_EL, RELIEF_FC )
{
    utils::runElementsRelationsCheck<RELIEF_EL, RELIEF_FC>(
            context, Severity::Fatal);
}

VALIDATOR_CHECK_PART(
        relief_relations, faces_relations, RELIEF_FC, RELIEF_EL, RELIEF )
{
    utils::runFacesRelationsCheck<RELIEF_FC, RELIEF>(context);
}

VALIDATOR_CHECK_PART(
        relief_relations, compound_objects_relations, RELIEF, RELIEF_FC )
{
    utils::runFeatureRelationsCheck<RELIEF>(context);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
