#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::RELIEF_FC;
using maps::wiki::validator::categories::RELIEF_EL;
using maps::wiki::validator::categories::RELIEF_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( relief_topology, segments_length, RELIEF_EL )
{
    utils::runSegmentsLengthCheck<RELIEF_EL>(context);
}

VALIDATOR_CHECK_PART( relief_topology, intersections, RELIEF_FC, RELIEF_EL )
{
    utils::runFaceElementsIntersectionsCheck<RELIEF_EL, RELIEF_FC>(context);
}

VALIDATOR_CHECK_PART( relief_topology, jc_el_coverage, RELIEF_EL, RELIEF_JC )
{
    utils::runJcElCoverageCheck<RELIEF_EL, RELIEF_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::No);
}

VALIDATOR_CHECK_PART( relief_topology, open_bounds, RELIEF_JC )
{
    utils::runOpenBoundsCheck<RELIEF_JC>(context);
}


} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
