#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/distance.h>

#include <unistd.h>

namespace gl = maps::geolib3;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

namespace {

const double ELEMENT_MIN_LENGTH = 2.0; // geo meters
const double PEDESTRIANS_ONLY_ELEMENT_MIN_LENGTH = 0.3; // geo meters

} // namespace

using categories::RD_EL;

VALIDATOR_SIMPLE_CHECK( length, RD_EL )
{
    context->objects<RD_EL>().visit(
            [&](const RoadElement* element) {
        double totalLength = 0.0;
        for (const auto& segment: element->geom().segments()) {
            gl::Point2 start = mercator2GeoPoint(segment.start());
            gl::Point2 end = mercator2GeoPoint(segment.end());
            double length = gl::fastGeoDistance(start, end);
            totalLength += length;
        }

        bool pedestriansOnly = (element->accessId() == common::AccessId::Pedestrian);

        if ((pedestriansOnly && totalLength < PEDESTRIANS_ONLY_ELEMENT_MIN_LENGTH) ||
            (!pedestriansOnly && totalLength < ELEMENT_MIN_LENGTH))
        {
            context->warning(
                "element-too-short",
                element->geom().segmentAt(0).midpoint(),
                {element->id()});
        }
    });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
