#include "module.h"
#include "../utils/misc.h"

#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using categories::RD_EL;

VALIDATOR_SIMPLE_CHECK( rd_el_pedestrian_crossing, RD_EL )
{
    context->objects<RD_EL>().visit(
        [&](const RoadElement* element) {
            if (element->fow() == common::FOW::PedestrianCrossing &&
               (element->accessId() == (element->accessId() | common::AccessId::Bicycle))) {
                    context->error("pedestrian-crossing-available-for-bicycle",
                           utils::geomForReport(element), {element->id()});
            }
        }
    );
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
