#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/message.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::RD_EL;
using maps::wiki::validator::categories::RD_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( rd_topology, segments_length, RD_EL )
{
    utils::runSegmentsLengthCheck<RD_EL>(context);
}

VALIDATOR_CHECK_PART( rd_topology, intersections, RD_EL )
{
    utils::runLinearElementsIntersectionsCheck<RD_EL>(
            context, Severity::Fatal);
}

VALIDATOR_CHECK_PART( rd_topology, jc_el_coverage, RD_EL, RD_JC )
{
    utils::runJcElCoverageCheck<RD_EL, RD_JC>(
            context, Severity::Fatal,
            [](const RD_EL::TObject* roadElement) {
                return roadElement->fc() == 10
                    ? Severity::Critical
                    : Severity::Fatal;
            },
            utils::CheckElementsAtJunction::Yes);
}


} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
