#include "module.h"

#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/check.h>

namespace maps::wiki::validator::checks {

using categories::MRC_PEDESTRIAN_REGION;

VALIDATOR_SIMPLE_CHECK( mrc_pedestrian_region_name_uniqueness, MRC_PEDESTRIAN_REGION )
{
    std::unordered_map<std::string, std::vector<TId>> nameToIds;
    context->objects<MRC_PEDESTRIAN_REGION>().visit([&](const MRC_PEDESTRIAN_REGION::TObject* region) {
        nameToIds[region->name()].push_back(region->id());
    });
    for (const auto& [_, ids] : nameToIds) {
        if (ids.size() > 1) {
            context->critical(
                "mrc_pedestrian_region-name-not-unique",
                boost::none,
                ids);
        }
    }
}

} // namespace maps::wiki::validator::checks
