#pragma once

#include <yandex/maps/wiki/validator/validator.h>

#include <list>
#include <map>
#include <set>

namespace maps {
namespace wiki {
namespace validation {

typedef validator::TCheckId CheckId;
typedef std::set<CheckId> CheckIds;

typedef validator::TCategoryId CategoryId;
typedef std::set<CategoryId> CategoryIds;


class ChecksSplitter
{
public:
    explicit ChecksSplitter(const validator::Validator& validator);

    std::list<CheckIds> split(CheckIds checks) const;

    const CategoryIds& categories(const CheckId& checkId) const;

private:
    size_t checksValue(const CheckIds& checks) const;
    CheckId findMaxCheckId(const CheckIds& checks) const;

    CategoryIds bigCategories(const CheckId& checkId) const;

    CategoryIds categories(const CheckIds& checks) const;

private:
    std::map<CheckId, CategoryIds> checkToCategories_;
    size_t categoriesCount_;
};

} // namespace validation
} // namespace wiki
} // namespace maps
