import yatest.common

from maps.wikimap.mapspro.libs.python.validator import Validator, ValidatorConfig


def available_checks():
    editor_config_path = yatest.common.source_path('maps/wikimap/mapspro/cfg/editor/editor.xml')
    validator_config = ValidatorConfig(editor_config_path)
    validator = Validator(validator_config)
    validator.init_modules()
    return sum([m.check_ids for m in validator.modules()], [])


def pytest_generate_tests(metafunc):
    if 'check' in metafunc.fixturenames:
        check = yatest.common.get_param('check')
        if check:
            metafunc.parametrize("check", [check])
        else:
            metafunc.parametrize("check", available_checks())
