import category_translators as cattrans

_AVAILABLE_CONVERTERS = {
    'RdToAd': cattrans.RD_TO_AD,
    'RdToMetro': cattrans.RD_TO_METRO,
    'RdToRailway': cattrans.RD_TO_RAILWAY,
    'RdToTram': cattrans.RD_TO_TRAM,
    'RdToWaterway': cattrans.RD_TO_WATERWAY,
    'RdToLinearHydro': cattrans.RD_TO_HYDRO_LN,
    'RdToContourHydro': cattrans.RD_TO_HYDRO_FC,
    'RdToRelief': cattrans.RD_TO_RELIEF,
    'RdToUrban': cattrans.RD_TO_URBAN,
    'RdToUrbanRoadnet': cattrans.RD_TO_URBAN_ROADNET,
    'RdToVegetation': cattrans.RD_TO_VEGETATION,
    'RdToAdNeutral': cattrans.RD_TO_AD_NEUTRAL,
    'AdToHydro': cattrans.AD_TO_HYDRO,
    'AdToRelief': cattrans.AD_TO_RELIEF,
    'AdToUrban': cattrans.AD_TO_URBAN,
    'AdToUrbanRoadnet': cattrans.AD_TO_URBAN_ROADNET,
    'AdToVegetation': cattrans.AD_TO_VEGETATION,
    'AdToAdNeutral': cattrans.AD_TO_AD_NEUTRAL,
    'UrbanToHydro': cattrans.URBAN_TO_HYDRO,
    'UrbanToRelief': cattrans.URBAN_TO_RELIEF,
    'UrbanToUrbanRoadnet': cattrans.URBAN_TO_URBAN_ROADNET,
    'UrbanToVegetation': cattrans.URBAN_TO_VEGETATION,

    'FeatureToBld': cattrans.FEATURE_TO_BLD,
    'FeatureToRelief': cattrans.FEATURE_TO_RELIEF,
    'FeatureToTransportAirport': cattrans.FEATURE_TO_TRANSPORT_AIRPORT,
    'FeatureToTransportAirportTerminal': cattrans.FEATURE_TO_TRANSPORT_AIRPORT_TERMINAL,
    'FeatureToTransportHelicopter': cattrans.FEATURE_TO_TRANSPORT_HELICOPTER,
    'FeatureToTransportStop': cattrans.FEATURE_TO_TRANSPORT_STOP,
    'FeatureToTransportTerminal': cattrans.FEATURE_TO_TRANSPORT_TERMINAL,
    'FeatureToTransportTram': cattrans.FEATURE_TO_TRANSPORT_TRAM,
    'FeatureToTransportWaterway': cattrans.FEATURE_TO_TRANSPORT_WATERWAY,
    'FeatureToVegetation': cattrans.FEATURE_TO_VEGETATION,
    'FeatureToTransportRailway': cattrans.FEATURE_TO_TRANSPORT_RAILWAY,
    'FeatureToHydro': cattrans.FEATURE_TO_HYDRO,
    'FeatureToUrban': cattrans.FEATURE_TO_URBAN,
    'FeatureToUrbanRoadnet': cattrans.FEATURE_TO_URBAN_ROADNET,
    'FeatureToAdNeutral': cattrans.FEATURE_TO_AD_NEUTRAL,
    'FeatureToRegion': cattrans.FEATURE_TO_REGION,
    'BusToTram': cattrans.BUS_TO_TRAM,
    'BusToWaterway': cattrans.BUS_TO_WATERWAY
}


def get(converter_name):
    return _AVAILABLE_CONVERTERS[converter_name]


def convert(converter_name, *args):
    return get(converter_name).convert(*args)
