import json
from yatest.common import source_path


DATA_FILE_PATH = source_path('maps/wikimap/mapspro/services/tasks/validator-checks/geocoder-requirements/geobase_id_check_data/geobase_id_map.json')


def test_no_duplicates():
    data = json.load(open(DATA_FILE_PATH))["geobase_check"]

    assert len(set([el["id"] for el in data])) == len(data)


def test_required_fields():
    data = json.load(open(DATA_FILE_PATH))["geobase_check"]

    for el in data:
        assert "id" in el
        assert "geobase_id" in el
