#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/geom.h"

#include <maps/libs/geolib/include/distance.h>

using maps::wiki::validator::categories::TRANSPORT_AIRPORT;
using maps::wiki::validator::categories::TRANSPORT_AIRPORT_TERMINAL;

namespace {

const double MAX_AIRPORT_TERMINAL_DISTANCE = 2000; // meters

} // namespace

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_SIMPLE_CHECK( transport_airport_geometry,
        TRANSPORT_AIRPORT, TRANSPORT_AIRPORT_TERMINAL)
{
    context->objects<TRANSPORT_AIRPORT_TERMINAL>().visit(
        [&](const PointFeature* terminal)
    {
        const TId id = terminal->id();
        const TId parentId = terminal->parent();
        if (parentId != 0
                && context->objects<TRANSPORT_AIRPORT>().loaded(parentId)) {
            const PointFeature* airport =
                context->objects<TRANSPORT_AIRPORT>().byId(parentId);
            double distanceRatio = utils::mercatorDistanceRatio(
                                           terminal->geom());
            if (maps::geolib3::distance(terminal->geom(), airport->geom())
                    * distanceRatio > MAX_AIRPORT_TERMINAL_DISTANCE) {
                context->error(
                        "terminal-too-far-from-airport",
                        terminal->geom(),
                        {id, parentId});
            }
        }
    });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
