#include "module.h"
#include "../utils/import_source.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

using maps::wiki::validator::categories::TRANSPORT_AIRPORT;
using maps::wiki::validator::categories::TRANSPORT_AIRPORT_TERMINAL;
using maps::wiki::validator::categories::TRANSPORT_HELICOPTER;

namespace maps::wiki::validator::checks {

VALIDATOR_CHECK_PART( transport_airport_import_source, airport, TRANSPORT_AIRPORT )
{
    utils::checkImportSource<TRANSPORT_AIRPORT>(context);
}

VALIDATOR_CHECK_PART( transport_airport_import_source, terminal, TRANSPORT_AIRPORT_TERMINAL )
{
    utils::checkImportSource<TRANSPORT_AIRPORT_TERMINAL>(context);
}

VALIDATOR_CHECK_PART( transport_airport_import_source, helicopter, TRANSPORT_HELICOPTER )
{
    utils::checkImportSource<TRANSPORT_HELICOPTER>(context);
}

} // namespace maps::wiki::validator::checks
