#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <functional>

using maps::wiki::validator::categories::TRANSPORT_AIRPORT;
using maps::wiki::validator::categories::TRANSPORT_AIRPORT_TERMINAL;
using maps::wiki::validator::categories::TRANSPORT_HELICOPTER;
using maps::wiki::validator::categories::TRANSPORT_AIRPORT_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( transport_airport_naming, airport,
    TRANSPORT_AIRPORT, TRANSPORT_AIRPORT_NM )
{
    context->objects<TRANSPORT_AIRPORT>().visit(
        [&](const PointFeature* point) {
            utils::runBasicNamesCheck<TRANSPORT_AIRPORT_NM>(point, context);
        }
    );
}

VALIDATOR_CHECK_PART( transport_airport_naming, terminal,
    TRANSPORT_AIRPORT_TERMINAL, TRANSPORT_AIRPORT_NM )
{
    context->objects<TRANSPORT_AIRPORT_TERMINAL>().visit(
        [&](const PointFeature* point) {
            utils::runBasicNamesCheck<TRANSPORT_AIRPORT_NM>(point, context);
        }
    );
}

VALIDATOR_CHECK_PART( transport_airport_naming, helicopter,
    TRANSPORT_HELICOPTER, TRANSPORT_AIRPORT_NM )
{
    context->objects<TRANSPORT_HELICOPTER>().visit(
        [&](const PointFeature* point) {
            utils::runBasicNamesCheck<TRANSPORT_AIRPORT_NM>(point, context);
        }
    );
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
