#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

using maps::wiki::validator::categories::TRANSPORT_AIRPORT;
using maps::wiki::validator::categories::TRANSPORT_AIRPORT_TERMINAL;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_SIMPLE_CHECK( transport_airport_relations,
        TRANSPORT_AIRPORT, TRANSPORT_AIRPORT_TERMINAL)
{
    context->objects<TRANSPORT_AIRPORT_TERMINAL>().visit(
        [&](const PointFeature* terminal)
        {
            const TId id = terminal->id();
            const TId parentId = terminal->parent();
            if (parentId == 0) {
                context->critical(
                    "stray-airport-terminal",
                    terminal->geom(),
                    {id}
                );
            }
        }
    );
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
