#include "module.h"
#include "../utils/misc.h"

#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include <maps/libs/geolib/include/convex_hull.h>

using maps::wiki::validator::categories::TRANSPORT_METRO_EXIT;
using maps::wiki::validator::categories::TRANSPORT_METRO_STATION;
using maps::wiki::validator::categories::TRANSPORT_PASSAGEWAY;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_SIMPLE_CHECK(transport_metro_exit,
    TRANSPORT_METRO_EXIT, TRANSPORT_METRO_STATION, TRANSPORT_PASSAGEWAY)
{
    context->objects<TRANSPORT_METRO_EXIT>().visit(
        [&](const TransportMetroExit* exit)
        {
            if (exit->station() == 0)
                return;

            for (TId passagewayId : exit->passageways()) {
                if (context->objects<TRANSPORT_PASSAGEWAY>().loaded(
                        passagewayId)) {
                    const TransportPassageway* passageway
                        = context->objects<TRANSPORT_PASSAGEWAY>().byId(
                            passagewayId);
                    // there is passageway from exit to assigned station
                    if (passageway->station() == exit->station())
                        return;
                }
            }

            context->error("exit-not-connected-to-station",
                           geolib3::bufferedConvexHull(
                               { context->objects<TRANSPORT_METRO_STATION>()
                                     .byId(exit->station())->geom(),
                                 exit->geom()
                               },
                               utils::BUFFER_DISTANCE),
                           {exit->id(), exit->station()});
        });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
