#include "module.h"
#include "../utils/import_source.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

using maps::wiki::validator::categories::TRANSPORT_METRO_STATION;
using maps::wiki::validator::categories::TRANSPORT_METRO_EXIT;
using maps::wiki::validator::categories::TRANSPORT_METRO_LINE;

namespace maps::wiki::validator::checks {

VALIDATOR_CHECK_PART( transport_metro_import_source, station, TRANSPORT_METRO_STATION )
{
    utils::checkImportSource<TRANSPORT_METRO_STATION>(context);
}

VALIDATOR_CHECK_PART( transport_metro_import_source, exit, TRANSPORT_METRO_EXIT )
{
    utils::checkImportSource<TRANSPORT_METRO_EXIT>(context);
}

VALIDATOR_CHECK_PART( transport_metro_import_source, line, TRANSPORT_METRO_LINE )
{
    utils::checkImportSource<TRANSPORT_METRO_LINE>(context);
}

} // namespace maps::wiki::validator::checks
