#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <boost/none.hpp>

using maps::wiki::validator::categories::TRANSPORT_METRO_LINE;
using maps::wiki::validator::categories::TRANSPORT_METRO_STATION;
using maps::wiki::validator::categories::TRANSPORT_METRO_EXIT;
using maps::wiki::validator::categories::TRANSPORT_METRO_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

namespace {

template<class TObject>
void runMetroNamesCheck(
        const TObject* object,
        const std::string& unnamedDescription,
        CheckContext* context)
{
    utils::runBasicNamesCheck<TRANSPORT_METRO_NM>(object, context);

    if (!utils::isNamed<TRANSPORT_METRO_NM>(object, context)) {
        context->error(
            unnamedDescription,
            boost::none,
            { object->id() });
    }
}

} // namespace

VALIDATOR_SIMPLE_CHECK( transport_metro_naming,
        TRANSPORT_METRO_LINE, TRANSPORT_METRO_STATION,
        TRANSPORT_METRO_EXIT, TRANSPORT_METRO_NM )
{
    context->objects<TRANSPORT_METRO_LINE>().visit(
        [&](const TransportLine* metroLine)
    { runMetroNamesCheck(metroLine, "unnamed-metro-line", context); });

    context->objects<TRANSPORT_METRO_STATION>().visit(
        [&](const TransportMetroStation* metroStation)
    { runMetroNamesCheck(metroStation, "unnamed-metro-station", context); });

    context->objects<TRANSPORT_METRO_EXIT>().visit(
        [&](const TransportMetroExit* metroExit)
    { runMetroNamesCheck(metroExit, "unnamed-metro-exit", context); });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
