#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/message.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::TRANSPORT_METRO_EL;
using maps::wiki::validator::categories::TRANSPORT_METRO_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( transport_metro_topology, segments_length,
        TRANSPORT_METRO_EL )
{
    utils::runSegmentsLengthCheck<TRANSPORT_METRO_EL>(context);
}

VALIDATOR_CHECK_PART( transport_metro_topology, intersections,
        TRANSPORT_METRO_EL )
{
    utils::runLinearElementsIntersectionsCheck<TRANSPORT_METRO_EL>(
            context, Severity::Warning);
}

VALIDATOR_CHECK_PART( transport_metro_topology, jc_el_coverage,
        TRANSPORT_METRO_EL, TRANSPORT_METRO_JC )
{
    utils::runJcElCoverageCheck<TRANSPORT_METRO_EL, TRANSPORT_METRO_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::Yes);
}


} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
