#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/polygon_checks.h"

using maps::wiki::validator::categories::TRANSPORT_RAILWAY_PLATFORM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_SIMPLE_CHECK( transport_railway_geometry, TRANSPORT_RAILWAY_PLATFORM )
{
    context->objects<TRANSPORT_RAILWAY_PLATFORM>().visit(
        [&](const PolygonFeature* platform) {
            utils::runPolygonGeometryCheck(platform, context);
        }
    );
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
