#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <functional>

using maps::wiki::validator::categories::TRANSPORT_RAILWAY;
using maps::wiki::validator::categories::TRANSPORT_RAILWAY_STATION;
using maps::wiki::validator::categories::TRANSPORT_RAILWAY_PLATFORM;
using maps::wiki::validator::categories::TRANSPORT_RAILWAY_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( transport_railway_naming, line,
    TRANSPORT_RAILWAY, TRANSPORT_RAILWAY_NM )
{
    context->objects<TRANSPORT_RAILWAY>().visit(
        [&](const LinearFeature* railway) {
            utils::runBasicNamesCheck<TRANSPORT_RAILWAY_NM>(railway, context);
        }
    );
}

VALIDATOR_CHECK_PART( transport_railway_naming, station,
    TRANSPORT_RAILWAY_STATION, TRANSPORT_RAILWAY_NM )
{
    context->objects<TRANSPORT_RAILWAY_STATION>().visit(
        [&](const PointFeature* station) {
            utils::runBasicNamesCheck<TRANSPORT_RAILWAY_NM>(station, context);
        }
    );
}

VALIDATOR_CHECK_PART( transport_railway_naming, platform,
    TRANSPORT_RAILWAY_PLATFORM, TRANSPORT_RAILWAY_NM )
{
    context->objects<TRANSPORT_RAILWAY_PLATFORM>().visit(
        [&](const PolygonFeature* platform) {
            utils::runBasicNamesCheck<TRANSPORT_RAILWAY_NM>(platform, context);
        }
    );
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
