#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/message.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::TRANSPORT_RAILWAY_EL;
using maps::wiki::validator::categories::TRANSPORT_RAILWAY_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( transport_railway_topology, segments_length,
        TRANSPORT_RAILWAY_EL )
{
    utils::runSegmentsLengthCheck<TRANSPORT_RAILWAY_EL>(context);
}

VALIDATOR_CHECK_PART( transport_railway_topology, intersections,
        TRANSPORT_RAILWAY_EL )
{
    utils::runLinearElementsIntersectionsCheck<TRANSPORT_RAILWAY_EL>(
            context, Severity::Warning);
}

VALIDATOR_CHECK_PART( transport_railway_topology, jc_el_coverage,
        TRANSPORT_RAILWAY_EL, TRANSPORT_RAILWAY_JC )
{
    utils::runJcElCoverageCheck<TRANSPORT_RAILWAY_EL, TRANSPORT_RAILWAY_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::Yes);
}


} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
