#include "module.h"
#include "../transport-thread-common/common.h"

#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>
namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using categories::TRANSPORT_OPERATOR;
using categories::TRANSPORT_BUS_ROUTE;
using categories::TRANSPORT_TRAM_ROUTE;
using categories::TRANSPORT_WATERWAY_ROUTE;

#define ROUTE_CATEGORIES \
    TRANSPORT_BUS_ROUTE, \
    TRANSPORT_TRAM_ROUTE, TRANSPORT_WATERWAY_ROUTE

template<typename... Categories>
void performChecks(CheckContext* context)
{
    auto performed = {performOperatorBindingCheck<Categories>(context)...};
    (void)performed;
}

VALIDATOR_SIMPLE_CHECK(transport_route_relations, ROUTE_CATEGORIES, TRANSPORT_OPERATOR)
{
    performChecks<ROUTE_CATEGORIES>(context);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
