#include "module.h"
#include "../utils/import_source.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

using maps::wiki::validator::categories::TRANSPORT_BUS_THREAD;
using maps::wiki::validator::categories::TRANSPORT_TRAM_THREAD;
using maps::wiki::validator::categories::TRANSPORT_WATERWAY_THREAD;

namespace maps::wiki::validator::checks {

VALIDATOR_CHECK_PART( transport_thread_import_source, bus, TRANSPORT_BUS_THREAD )
{
    utils::checkImportSource<TRANSPORT_BUS_THREAD>(context);
}

VALIDATOR_CHECK_PART( transport_thread_import_source, tram, TRANSPORT_TRAM_THREAD )
{
    utils::checkImportSource<TRANSPORT_TRAM_THREAD>(context);
}

VALIDATOR_CHECK_PART( transport_thread_import_source, waterway, TRANSPORT_WATERWAY_THREAD )
{
    utils::checkImportSource<TRANSPORT_WATERWAY_THREAD>(context);
}

} // namespace maps::wiki::validator::checks
