#include "module.h"
#include "../utils/import_source.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

using maps::wiki::validator::categories::TRANSPORT_WATERWAY_STOP;
using maps::wiki::validator::categories::TRANSPORT_WATERWAY_ROUTE;

namespace maps::wiki::validator::checks {

VALIDATOR_CHECK_PART( transport_waterway_import_source, stop, TRANSPORT_WATERWAY_STOP )
{
    utils::checkImportSource<TRANSPORT_WATERWAY_STOP>(context);
}

VALIDATOR_CHECK_PART( transport_waterway_import_source, route, TRANSPORT_WATERWAY_ROUTE )
{
    utils::checkImportSource<TRANSPORT_WATERWAY_ROUTE>(context);
}

} // namespace maps::wiki::validator::checks
