#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <functional>

using maps::wiki::validator::categories::TRANSPORT_WATERWAY_ROUTE;
using maps::wiki::validator::categories::TRANSPORT_WATERWAY_STOP;
using maps::wiki::validator::categories::TRANSPORT_WATERWAY_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( transport_waterway_naming, waterway,
    TRANSPORT_WATERWAY_ROUTE, TRANSPORT_WATERWAY_NM )
{
    context->objects<TRANSPORT_WATERWAY_ROUTE>().visit(
        [&](const TransportLine* waterway) {
            utils::runBasicNamesCheck<TRANSPORT_WATERWAY_NM>(waterway, context);
        }
    );

}

VALIDATOR_CHECK_PART( transport_waterway_naming, stop,
    TRANSPORT_WATERWAY_STOP, TRANSPORT_WATERWAY_NM )
{
    context->objects<TRANSPORT_WATERWAY_STOP>().visit(
        [&](const TransportStop* stop) {
            utils::runBasicNamesCheck<TRANSPORT_WATERWAY_NM>(stop, context);
        }
    );
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
