#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/message.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::TRANSPORT_WATERWAY_EL;
using maps::wiki::validator::categories::TRANSPORT_WATERWAY_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( transport_waterway_topology, segments_length,
        TRANSPORT_WATERWAY_EL )
{
    utils::runSegmentsLengthCheck<TRANSPORT_WATERWAY_EL>(context);
}

VALIDATOR_CHECK_PART( transport_waterway_topology, intersections,
        TRANSPORT_WATERWAY_EL )
{
    utils::runLinearElementsIntersectionsCheck<TRANSPORT_WATERWAY_EL>(
            context, Severity::Warning);
}

VALIDATOR_CHECK_PART( transport_waterway_topology, jc_el_coverage,
        TRANSPORT_WATERWAY_EL, TRANSPORT_WATERWAY_JC )
{
    utils::runJcElCoverageCheck<TRANSPORT_WATERWAY_EL, TRANSPORT_WATERWAY_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::Yes);
}


} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
