#include "module.h"
#include "../utils/import_source.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

using maps::wiki::validator::categories::TRANSPORT_STOP;
using maps::wiki::validator::categories::TRANSPORT_TERMINAL;
using maps::wiki::validator::categories::TRANSPORT_BUS_ROUTE;
using maps::wiki::validator::categories::TRANSPORT_TRAM_ROUTE;

namespace maps::wiki::validator::checks {

VALIDATOR_CHECK_PART( transport_import_source, stop, TRANSPORT_STOP )
{
    utils::checkImportSource<TRANSPORT_STOP>(context);
}

VALIDATOR_CHECK_PART( transport_import_source, terminal, TRANSPORT_TERMINAL )
{
    utils::checkImportSource<TRANSPORT_TERMINAL>(context);
}

VALIDATOR_CHECK_PART( transport_import_source, bus, TRANSPORT_BUS_ROUTE )
{
    utils::checkImportSource<TRANSPORT_BUS_ROUTE>(context);
}

VALIDATOR_CHECK_PART( transport_import_source, tram, TRANSPORT_TRAM_ROUTE )
{
    utils::checkImportSource<TRANSPORT_TRAM_ROUTE>(context);
}

} // namespace maps::wiki::validator::checks
