#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <functional>

using maps::wiki::validator::categories::TRANSPORT_STOP;
using maps::wiki::validator::categories::TRANSPORT_TERMINAL;
using maps::wiki::validator::categories::TRANSPORT_TRAM_ROUTE;
using maps::wiki::validator::categories::TRANSPORT_BUS_ROUTE;
using maps::wiki::validator::categories::TRANSPORT_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( transport_naming, tram, TRANSPORT_TRAM_ROUTE, TRANSPORT_NM )
{
    context->objects<TRANSPORT_TRAM_ROUTE>().visit(
        [&](const TransportLine* route) {
            utils::runBasicNamesCheck<TRANSPORT_NM>(route, context);
        }
    );
}

VALIDATOR_CHECK_PART( transport_naming, bus, TRANSPORT_BUS_ROUTE, TRANSPORT_NM )
{
    context->objects<TRANSPORT_BUS_ROUTE>().visit(
        [&](const TransportLine* route) {
            utils::runBasicNamesCheck<TRANSPORT_NM>(route, context);
        }
    );
}

VALIDATOR_CHECK_PART( transport_naming, stop, TRANSPORT_STOP, TRANSPORT_NM )
{
    context->objects<TRANSPORT_STOP>().visit(
        [&](const TransportStop* stop) {
            utils::runBasicNamesCheck<TRANSPORT_NM>(stop, context);
        }
    );
}

VALIDATOR_CHECK_PART( transport_naming, terminal, TRANSPORT_TERMINAL, TRANSPORT_NM )
{
    context->objects<TRANSPORT_TERMINAL>().visit(
        [&](const PointFeature* point) {
            utils::runBasicNamesCheck<TRANSPORT_NM>(point, context);
        }
    );
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
