#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/message.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::TRANSPORT_TRAM_EL;
using maps::wiki::validator::categories::TRANSPORT_TRAM_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( transport_tram_topology, segments_length,
        TRANSPORT_TRAM_EL )
{
    utils::runSegmentsLengthCheck<TRANSPORT_TRAM_EL>(context);
}

VALIDATOR_CHECK_PART( transport_tram_topology, intersections,
        TRANSPORT_TRAM_EL )
{
    utils::runLinearElementsIntersectionsCheck<TRANSPORT_TRAM_EL>(
            context, Severity::Warning);
}

VALIDATOR_CHECK_PART( transport_tram_topology, jc_el_coverage,
        TRANSPORT_TRAM_EL, TRANSPORT_TRAM_JC )
{
    utils::runJcElCoverageCheck<TRANSPORT_TRAM_EL, TRANSPORT_TRAM_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::Yes);
}


} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
