#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/face_checks.h"
#include "../utils/polygon_checks.h"

using maps::wiki::validator::categories::URBAN_ROADNET;
using maps::wiki::validator::categories::URBAN_ROADNET_FC;
using maps::wiki::validator::categories::URBAN_ROADNET_EL;
using maps::wiki::validator::categories::URBAN_ROADNET_AREAL;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

namespace {

const size_t VISIT_BATCH_SIZE = 10000;

} // namespace

VALIDATOR_CHECK_PART( urban_roadnet_geometry, contour_geometry,
        URBAN_ROADNET, URBAN_ROADNET_FC, URBAN_ROADNET_EL )
{
    utils::runFaceIntersectionsNestingCheck<URBAN_ROADNET>(context);
}

VALIDATOR_CHECK_PART( urban_roadnet_geometry, polygon_geometry,
        URBAN_ROADNET_AREAL )
{
    context->objects<URBAN_ROADNET_AREAL>().batchVisit(
            [&](const PolygonFeature* roadnet)
    {
        utils::runPolygonGeometryCheck(roadnet, context);
    }, VISIT_BATCH_SIZE);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
