#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <functional>

using maps::wiki::validator::categories::URBAN_ROADNET;
using maps::wiki::validator::categories::URBAN_ROADNET_AREAL;
using maps::wiki::validator::categories::URBAN_ROADNET_PARKING_LOT;
using maps::wiki::validator::categories::URBAN_ROADNET_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( urban_roadnet_naming, roadnet, URBAN_ROADNET, URBAN_ROADNET_NM )
{
    context->objects<URBAN_ROADNET>().visit(
        [&](const ContourFeature* roadnet) {
            utils::runBasicNamesCheck<URBAN_ROADNET_NM>(roadnet, context);
        }
    );
}

VALIDATOR_CHECK_PART( urban_roadnet_naming, parking, URBAN_ROADNET_PARKING_LOT, URBAN_ROADNET_NM )
{
    context->objects<URBAN_ROADNET_PARKING_LOT>().visit(
        [&](const ParkingLot* parking) {
            utils::runBasicNamesCheck<URBAN_ROADNET_NM>(parking, context);
        }
    );
}

VALIDATOR_CHECK_PART( urban_roadnet_naming, areal, URBAN_ROADNET_AREAL, URBAN_ROADNET_NM )
{
    context->objects<URBAN_ROADNET_AREAL>().visit(
        [&](const PolygonFeature* areal) {
            utils::runBasicNamesCheck<URBAN_ROADNET_NM>(areal, context);
        }
    );
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
