#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/relations_checks.h"

using maps::wiki::validator::categories::URBAN_ROADNET;
using maps::wiki::validator::categories::URBAN_ROADNET_FC;
using maps::wiki::validator::categories::URBAN_ROADNET_EL;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART(
        urban_roadnet_relations, elements_relations, URBAN_ROADNET_EL, URBAN_ROADNET_FC )
{
    utils::runElementsRelationsCheck<URBAN_ROADNET_EL, URBAN_ROADNET_FC>(
            context, Severity::Critical);
}

VALIDATOR_CHECK_PART(
        urban_roadnet_relations, faces_relations, URBAN_ROADNET_FC, URBAN_ROADNET_EL, URBAN_ROADNET )
{
    utils::runFacesRelationsCheck<URBAN_ROADNET_FC, URBAN_ROADNET>(context);
}

VALIDATOR_CHECK_PART(
        urban_roadnet_relations, compound_objects_relations,
        URBAN_ROADNET, URBAN_ROADNET_FC )
{
    utils::runFeatureRelationsCheck<URBAN_ROADNET>(context);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
