#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::URBAN_ROADNET_FC;
using maps::wiki::validator::categories::URBAN_ROADNET_EL;
using maps::wiki::validator::categories::URBAN_ROADNET_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( urban_roadnet_topology, segments_length,
        URBAN_ROADNET_EL )
{
    utils::runSegmentsLengthCheck<URBAN_ROADNET_EL>(context);
}

VALIDATOR_CHECK_PART( urban_roadnet_topology, intersections,
        URBAN_ROADNET_FC, URBAN_ROADNET_EL )
{
    utils::runFaceElementsIntersectionsCheck<
            URBAN_ROADNET_EL, URBAN_ROADNET_FC>(context);
}

VALIDATOR_CHECK_PART( urban_roadnet_topology, jc_el_coverage,
        URBAN_ROADNET_EL, URBAN_ROADNET_JC )
{
    utils::runJcElCoverageCheck<URBAN_ROADNET_EL, URBAN_ROADNET_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::No);
}

VALIDATOR_CHECK_PART( urban_roadnet_topology, open_bounds, URBAN_ROADNET_JC )
{
    utils::runOpenBoundsCheck<URBAN_ROADNET_JC>(context);
}


} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
