#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/face_builder.h"
#include "../utils/face_checks.h"
#include "../utils/misc.h"

using maps::wiki::validator::categories::URBAN_FC;
using maps::wiki::validator::categories::URBAN_EL;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

namespace {

const double MIN_FACE_AREA = 60.0; // square meters
const double MAX_FACE_PERIMETER_TO_AREA_RATIO = 1.5; // meters / meters^2

} // namespace

VALIDATOR_SIMPLE_CHECK( urban_fc_validity, URBAN_FC, URBAN_EL )
{
    utils::runFaceValidityCheck<URBAN_FC>(context);

    utils::runFaceDimensionsCheck<URBAN_FC>(
            context,
            Severity::Warning,
            MIN_FACE_AREA,
            MAX_FACE_PERIMETER_TO_AREA_RATIO);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
