#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <functional>

using maps::wiki::validator::categories::URBAN;
using maps::wiki::validator::categories::URBAN_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_SIMPLE_CHECK( urban_naming, URBAN, URBAN_NM )
{
    context->objects<URBAN>().visit([&](const ContourFeature* urban)
    { utils::runBasicNamesCheck<URBAN_NM>(urban, context); });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
