#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/relations_checks.h"

using maps::wiki::validator::categories::URBAN;
using maps::wiki::validator::categories::URBAN_FC;
using maps::wiki::validator::categories::URBAN_EL;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART(
        urban_relations, face_elements_relations, URBAN_EL, URBAN_FC )
{
    utils::runElementsRelationsCheck<URBAN_EL, URBAN_FC>(
            context, Severity::Critical);
}

VALIDATOR_CHECK_PART(
        urban_relations, faces_relations, URBAN_FC, URBAN_EL, URBAN )
{
    utils::runFacesRelationsCheck<URBAN_FC, URBAN>(context);
}

VALIDATOR_CHECK_PART(
        urban_relations, compound_objects_relations, URBAN, URBAN_FC )
{
    utils::runFeatureRelationsCheck<URBAN>(context);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
