#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::URBAN_FC;
using maps::wiki::validator::categories::URBAN_EL;
using maps::wiki::validator::categories::URBAN_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( urban_topology, segments_length, URBAN_EL )
{
    utils::runSegmentsLengthCheck<URBAN_EL>(context);
}

VALIDATOR_CHECK_PART( urban_topology, intersections, URBAN_FC, URBAN_EL )
{
    utils::runFaceElementsIntersectionsCheck<URBAN_EL, URBAN_FC>(context);
}

VALIDATOR_CHECK_PART( urban_topology, jc_el_coverage, URBAN_EL, URBAN_JC )
{
    utils::runJcElCoverageCheck<URBAN_EL, URBAN_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::No);
}

VALIDATOR_CHECK_PART( urban_topology, open_bounds, URBAN_JC )
{
    utils::runOpenBoundsCheck<URBAN_JC>(context);
}


} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
