#pragma once

#include <yandex/maps/wiki/validator/categories.h>

namespace maps {
namespace wiki {
namespace validator {
namespace utils {

template<class Category>
struct ElementCategory
{ };

template<class Category>
struct FaceCategory
{ };

// Face element categories

template<>
struct ElementCategory<categories::AD_FC>
{ typedef categories::AD_EL type; };

template<>
struct ElementCategory<categories::AD_SUBST_FC>
{ typedef categories::AD_EL type; };

template<>
struct ElementCategory<categories::HYDRO_FC>
{ typedef categories::HYDRO_FC_EL type; };

template<>
struct ElementCategory<categories::VEGETATION_FC>
{ typedef categories::VEGETATION_EL type; };

template<>
struct ElementCategory<categories::RELIEF_FC>
{ typedef categories::RELIEF_EL type; };

template<>
struct ElementCategory<categories::URBAN_FC>
{ typedef categories::URBAN_EL type; };

template<>
struct ElementCategory<categories::URBAN_ROADNET_FC>
{ typedef categories::URBAN_ROADNET_EL type; };

template<>
struct ElementCategory<categories::AD_NEUTRAL_FC>
{ typedef categories::AD_NEUTRAL_EL type; };

// Object element categories

template<>
struct ElementCategory<categories::RD>
{ typedef categories::RD_EL type; };

template<>
struct ElementCategory<categories::TRANSPORT_METRO_LINE>
{ typedef categories::TRANSPORT_METRO_EL type; };

template<>
struct ElementCategory<categories::TRANSPORT_RAILWAY>
{ typedef categories::TRANSPORT_RAILWAY_EL type; };

template<>
struct ElementCategory<categories::TRANSPORT_TRAM_ROUTE>
{ typedef categories::TRANSPORT_TRAM_EL type; };

template<>
struct ElementCategory<categories::TRANSPORT_WATERWAY_ROUTE>
{ typedef categories::TRANSPORT_WATERWAY_EL type; };

template<>
struct ElementCategory<categories::HYDRO_LN>
{ typedef categories::HYDRO_LN_EL type; };

// Object face categories

template<>
struct FaceCategory<categories::AD>
{ typedef categories::AD_FC type; };

template<>
struct FaceCategory<categories::AD_SUBST>
{ typedef categories::AD_SUBST_FC type; };

template<>
struct FaceCategory<categories::HYDRO>
{ typedef categories::HYDRO_FC type; };

template<>
struct FaceCategory<categories::VEGETATION>
{ typedef categories::VEGETATION_FC type; };

template<>
struct FaceCategory<categories::RELIEF>
{ typedef categories::RELIEF_FC type; };

template<>
struct FaceCategory<categories::URBAN>
{ typedef categories::URBAN_FC type; };

template<>
struct FaceCategory<categories::URBAN_ROADNET>
{ typedef categories::URBAN_ROADNET_FC type; };

template<>
struct FaceCategory<categories::AD_NEUTRAL>
{ typedef categories::AD_NEUTRAL_FC type; };

} // namespace utils
} // namespace validator
} // namespace wiki
} // namespace maps
