#pragma once

#include <vector>
#include <cstddef>

namespace maps {
namespace wiki {
namespace validator {
namespace utils {

class DisjointSets
{
public:
    explicit DisjointSets(size_t size);

    size_t find(size_t x) const;

    void unionize(size_t x, size_t y);

    size_t numClusters() const
    { return numClusters_; }

    std::vector<std::vector<size_t>> clusters() const;

private:
    size_t numClusters_;

    std::vector<size_t> ranks_;
    mutable std::vector<size_t> parents_;
};

} // namespace utils
} // namespace validator
} // namespace wiki
} // namespace maps
