#pragma once

#include "face_builder.h"

#include <yandex/maps/wiki/validator/message.h>
#include <maps/libs/geolib/include/polygon.h>

#include <boost/optional.hpp>
#include <set>
#include <vector>

namespace maps {
namespace wiki {
namespace validator {

class CheckContext;

namespace utils {

namespace detail {

const size_t VISIT_BATCH_SIZE = 1000;

} // namespace detail

// Requires face elements to be loaded
template<class FaceCategory>
void runFaceValidityCheck(CheckContext* context);

// Requires face elements to be loaded
template<class FaceCategory>
void runFaceDimensionsCheck(
        CheckContext* context,
        Severity severity,
        double minArea,
        double maxPerimeterToAreaRatio);

// Requires faces and face elements to be loaded
template<class CompoundObjectCategory>
void runFaceIntersectionsNestingCheck(
        CheckContext* context,
        size_t batchSize = detail::VISIT_BATCH_SIZE);

inline boost::optional<geolib3::Polygon2> facePolygon(
        const FaceBuilder& faceBuilder);

} // namespace utils
} // namespace validator
} // namespace wiki
} // namespace maps

#define VALIDATOR_CHECKS_UTILS_FACE_CHECKS_INL
#include "face_checks-inl.h"
#undef VALIDATOR_CHECKS_UTILS_FACE_CHECKS_INL
