#pragma once

#include <cstddef>
#include <vector>
#include <utility>

namespace maps {
namespace wiki {
namespace validator {
namespace utils {

// Clusterizes provided geometries by distance and returns pairs of indices
// corresponding to closest geometries in distinct clusters.
//
// minGapDistance -- minimal allowed distance between clusters
template<class TGeom>
std::vector<std::pair<size_t, size_t>> findGapsRepresentatives(
        const std::vector<TGeom>& geoms,
        double minGapDistance);

} // namespace utils
} // namespace validator
} // namespace wiki
} // namespace maps
