#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/check_context.h>

#include <maps/libs/common/include/exception.h>

#include <boost/iterator/iterator_adaptor.hpp>
#include <utility>
#include <vector>

namespace maps {
namespace wiki {
namespace validator {
namespace utils {

template<class ObjectCategory>
class ObjectsGeomIterator
        : public boost::iterator_adaptor<
            ObjectsGeomIterator<ObjectCategory>,
            std::vector<TId>::const_iterator,
            const typename ObjectCategory::TObject::TGeom>
{
public:
    ObjectsGeomIterator(
            typename ObjectsGeomIterator::base_type it,
            CheckContext* context)
        : ObjectsGeomIterator::iterator_adaptor_(std::move(it))
        , context_(context)
    { }

private:
    friend class boost::iterator_core_access;

    typename ObjectsGeomIterator::reference dereference() const
    {
        TId currentId = *this->base();
        REQUIRE(
            context_->objects<ObjectCategory>().loaded(currentId),
            "Iterating over missing object, id: " << currentId);
        return context_->objects<ObjectCategory>().byId(currentId)->geom();
    }

private:
    CheckContext* context_;
};

template<class ObjectCategory>
struct ObjectsGeomIteratorRange
{
    typedef std::pair<
        ObjectsGeomIterator<ObjectCategory>,
        ObjectsGeomIterator<ObjectCategory>> type;

    ObjectsGeomIteratorRange() = delete;
};

template<class ObjectCategory>
typename ObjectsGeomIteratorRange<ObjectCategory>::type geomIteratorRange(
        const std::vector<TId>& ids,
        CheckContext* context)
{
    return std::make_pair(
        ObjectsGeomIterator<ObjectCategory>(std::begin(ids), context),
        ObjectsGeomIterator<ObjectCategory>(std::end(ids), context));
}

} // namespace utils
} // namespace validator
} // namespace wiki
} // namespace maps
