#pragma once

#include <yandex/maps/wiki/validator/has_geom.h>
#include <yandex/maps/wiki/validator/check_context.h>

namespace maps::wiki::validator::utils {

template<typename Category>
void checkImportSource(CheckContext* context)
{
    context->objects<Category>().visit(
        [&](const auto* obj) {
            if (obj->importSourceId().empty() != obj->importSource().empty()) {
                if constexpr (HasGeom<typename Category::TObject>::value) {
                     context->fatal("bad-import-source", obj->geom(), { obj->id() });
                } else {
                     context->fatal("bad-import-source", boost::none, { obj->id() });
                }
            }
        }
    );
}

} // namespace maps::wiki::validator::utils
