#pragma once

namespace maps::wiki::validator::utils {

enum class IncidenceDirection {
    In = (1 << 0),
    Out = (1 << 1),
    Both = In | Out
};

constexpr bool isSet(IncidenceDirection toCheck, IncidenceDirection flags)
{
    return (static_cast<int>(toCheck) & static_cast<int>(flags)) == static_cast<int>(toCheck);
}

constexpr IncidenceDirection operator&(IncidenceDirection lhs, IncidenceDirection rhs)
{
    return static_cast<IncidenceDirection>(static_cast<int>(lhs) & static_cast<int>(rhs));
}

constexpr IncidenceDirection operator|(IncidenceDirection lhs, IncidenceDirection rhs)
{
    return static_cast<IncidenceDirection>(static_cast<int>(lhs) | static_cast<int>(rhs));
}

} // namespace maps::wiki::validator::utils
