#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/check_context.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/geolib/include/point.h>

#include <boost/optional.hpp>
#include <algorithm>
#include <cctype>
#include <stdexcept>
#include <string>
#include <unordered_set>

namespace maps {
namespace wiki {
namespace validator {
namespace utils {

static const double EPS = 0.05;

const double BUFFER_DISTANCE = 5.0;

template<class Element>
maps::geolib3::Point2 geomForReport(const Element* element)
{ return element->geom().segmentAt(0).midpoint(); }

template<class Element>
TId oppositeJunctionId(const Element* element, const TId junctionId)
{
    if (element->startJunction() == junctionId) {
        return element->endJunction();
    }
    if (element->endJunction() == junctionId) {
        return element->startJunction();
    }
    return TId();
}

inline boost::optional<unsigned long> parseDecimalUlong(
        const std::string& str)
{
    if (!std::all_of(str.cbegin(), str.cend(), ::isdigit)) {
        return boost::none;
    }
    try {
        return std::stoul(str);
    } catch (const std::logic_error&) {
        return boost::none;
    }
}

} // namespace utils
} // namespace validator
} // namespace wiki
} // namespace maps
