#pragma once

#include <functional>
#include <string>
#include <vector>

namespace maps {
namespace wiki {
namespace validator {

struct NameDatum
{
    std::string name;
    std::string lang;
    bool isLocal;
};

inline bool operator==(const NameDatum& lhs, const NameDatum& rhs)
{ return lhs.lang == rhs.lang && lhs.name == rhs.name; }

typedef std::vector<NameDatum> NameData;

const std::string LANG_RU = "ru";
const std::string LANG_UK = "uk";

} // namespace validator
} // namespace wiki
} // namespace maps

namespace std {

template<>
struct hash<maps::wiki::validator::NameDatum>
{
    typedef size_t result_type;
    typedef maps::wiki::validator::NameDatum argument_type;

    size_t operator()(const maps::wiki::validator::NameDatum& datum) const
    { return hash<string>()(datum.lang) ^ hash<string>()(datum.name); }
};

} // namespace std
